<div id="widget-server-stats" class="col-md-12">
    <div class="messages"></div>
	<table class="table table-striped table-bordered table-server-stats">
		<thead>
            <tr>
                <th colspan="3">Server stats</th>
            </tr>
			<tr>
				<th>Stat</th>
				<th>Value</th>
				<th>Updated ago</th>
			</tr>
		</thead>
		<tbody>
        <?php foreach($serverstats as $serverstat) : ?>
			<tr data-stat="<?= $serverstat['name']; ?>">
                <td><?= $serverstat['title']; ?></td>
				<td><?= $serverstat['value']; ?></td>
				<td><?= $serverstat['updated_at']; ?></td>
            </tr>
        <?php endforeach; ?>
		</tbody>
	</table>
</div>

<script type="text/javascript" async>
    $(document).ready(function() {
        var $widgetServerStats = $('#widget-server-stats');
        var $messagesServerStats = $('.messages', $widgetServerStats);
        var $tableServerStats = $('.table-server-stats', $widgetServerStats);
        var updatePeriod = 10000;
        
        var updateServerStats;
        updateServerStats = function() {
            $.ajax({
                type: 'GET',
                url: 'serverstats/get_stats',
                dataType: 'json'
            })
            .done(function(serverstats) {
                for(var i = 0; i < serverstats.length; ++i) {
                    var serverstat = serverstats[i];
                    var $tr = $('tbody > tr[data-stat="' + serverstat.name + '"]', $tableServerStats);
                    $tr.children('td:eq(0)').html(serverstat.title);
                    $tr.children('td:eq(1)').html(serverstat.value);
                    $tr.children('td:eq(2)').html(serverstat.updated_at);
                }
            })
            .fail(function(xhr, status, error) {
                var errorMsg;
                try {
                    var responseJson = JSON.parse(xhr.responseText);
                    errorMsg = responseJson.errorMsg;
                } catch(e) {
                    errorMsg = 'Error getting stats';
                }
                
                $messagesServerStats.html('' +
                    '<div class="alert alert-danger alert-dismissible" role="alert">' +
                        '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' +
                        '<strong>Error!</strong> ' + errorMsg +
                    '</div>'
                );
            })
            .always(function() {
                setTimeout(function() {
                    updateServerStats();
                }, updatePeriod);
            });
        };
        setTimeout(function() {
            updateServerStats();
        }, updatePeriod);
    });
</script>

<div id="widget-problems" class="col-md-12" style="margin-top: 80px;">
    <div class="messages"></div>
    <?= Form::open('/serverstats/delete_problem'); ?>
	<table class="table table-striped table-bordered">
		<thead>
            <tr>
                <th colspan="6">Problems</th>
            </tr>
			<tr>
				<th>Server</th>
				<th>Filename</th>
				<th>Logline</th>
				<th>Description</th>
				<th>Timestamp</th>
				<th>Hide</th>
			</tr>
		</thead>
		<tbody>
        <?php foreach($problems as $problem) : ?>
			<tr data-problem_id="<?= $problem->id; ?>">
                <td><?= $problem->server; ?></td>
                <td><?= $problem->filename; ?></td>
                <td><?= $problem->getLoglineFormatted(); ?></td>
                <td><?= $problem->description; ?></td>
                <td><?= $problem->created_at; ?></td>
                <td><?= Form::checkbox('delete[' . $problem->id . ']', '1', false, ['class' => 'delete-problem']); ?></td>
            </tr>
        <?php endforeach; unset($problem); ?>
		</tbody>
	</table>
    <?= Form::close(); ?>
</div>

<script type="text/javascript" async>
    $(document).ready(function() {
        var $widgetProblems = $('#widget-problems');
        var $messagesProblems = $('.messages', $widgetProblems);
        var $tableBodyProblems = $('table > tbody', $widgetProblems);
        var deletedProblemsIds = {};
        var updatePeriod = 10000;

        var setProblemsHooks = function($tableBodyProblems) {
            $tableBodyProblems.children('tr').each(function() {
                var $tr = $(this);
                $('.delete-problem', $tr).on('click', function(e) {
                    var problem_id = $tr.data('problem_id');
                    $.ajax({
                        type: 'POST',
                        url: $tr.closest('form').attr('action'),
                        dataType: 'json',
                        data: {
                            'problem_id': problem_id,
                        }
                    })
                    .done(function() {
                        deletedProblemsIds[problem_id] = true;
                        $tr.fadeOut(300, function() {
                            $tr.remove();
                        });
                    })
                    .fail(function() {
                        $tr.prop('checked', false);
                    });
                });
            });
        };
        setProblemsHooks($tableBodyProblems);

        var updateProblems;
        updateProblems = function() {
            $.ajax({
                type: 'GET',
                url: 'serverstats/get_problems',
                dataType: 'json'
            })
            .done(function(problems) {
                var tbody = [];
                for(var i = 0; i < problems.length; ++i) {
                    var problem = problems[i];
                    if (deletedProblemsIds[problem.id]) {
                        continue;
                    }
                    tbody.push('<tr data-problem_id="' + problem.id + '">');
                    tbody.push('<td>' + problem.server + '</td>');
                    tbody.push('<td>' + problem.filename + '</td>');
                    tbody.push('<td>' + problem.logline + '</td>');
                    tbody.push('<td>' + problem.description + '</td>');
                    tbody.push('<td>' + problem.created_at + '</td>');
                    tbody.push('<td><input type="checkbox" name="delete[' + problem.id + ']" value="1" class="delete-problem"></td>');
                    tbody.push('</tr>');
                }
                $tableBodyProblems.html(tbody.join(''));
                setProblemsHooks($tableBodyProblems);
            })
            .fail(function(xhr, status, error) {
                var errorMsg;
                try {
                    var responseJson = JSON.parse(xhr.responseText);
                    errorMsg = responseJson.errorMsg;
                } catch(e) {
                    errorMsg = 'Error getting problems';
                }
                
                $messagesProblems.html('' +
                    '<div class="alert alert-danger alert-dismissible" role="alert">' +
                        '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' +
                        '<strong>Error!</strong> ' + errorMsg +
                    '</div>'
                );
            })
            .always(function() {
                setTimeout(function() {
                    updateProblems();
                }, updatePeriod);
            });
        };
        setTimeout(function() {
            updateProblems();
        }, updatePeriod);
    });
</script>